<?php
/**
 * Plugin Name: Anna EasyCookiesPlus
 * Description: A simple WordPress plugin for managing cookie consent with customizable options.
 * Version: 1.4
 * Author: Anna Nicole kučerová  See also: <a href="https://nicoledigital.cz" target="_blank">NicoleDigital Network</a>
 */

if (!defined('ABSPATH')) {
    exit;
}

// Register settings menu
function easycookiesplus_menu() {
    add_menu_page(
        'EasyCookiesplus Settings',
        'EasyCookiesplus',
        'manage_options',
        'easycookiesplus',
        'easycookiesplus_settings_page',
        'dashicons-admin-generic',
        100
    );

    add_submenu_page(
        'easycookiesplus',
        'Cookie Policy Guide',
        'Cookie Policy Guide',
        'manage_options',
        'easycookiesplus_policy',
        'easycookiesplus_policy_page'
    );
}
add_action('admin_menu', 'easycookiesplus_menu');

// Create main settings page
function easycookiesplus_settings_page() {
    ?>
    <div class="wrap">
        <h1>EasyCookiesplus Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('easycookiesplus_settings_group');
            do_settings_sections('easycookiesplus');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

// Create sub-menu for Cookie Policy Guide
function easycookiesplus_policy_page() {
    ?>
    <div class="wrap">
        <h1>Cookie Policy Guide</h1>
        <p>Writing a cookie policy is important to inform users about how cookies are used on your website.</p>
        <h2>Cookie Policy - Example</h2>
        <h3>1. Introduction</h3>
        <p>
            This Cookie Policy explains how <strong>[Your Website Name]</strong> ("we," "us," or "our") uses cookies and similar technologies 
            to improve your experience while using our website.
        </p>
        <p>
            By visiting and using our website, you agree to the use of cookies as described in this policy. 
            You can manage your cookie preferences at any time through your browser settings or our website's cookie banner.
        </p>

        <h3>2. What Are Cookies?</h3>
        <p>
            Cookies are small text files that websites place on your device (computer, tablet, smartphone) to store 
            information about your preferences, login details, and browsing behavior.
        </p>
        <p>Cookies help us:</p>
        <ul>
            <li>Improve website functionality and security.</li>
            <li>Personalize your experience.</li>
            <li>Analyze website performance and traffic.</li>
            <li>Provide targeted advertisements.</li>
        </ul>

        <h3>3. Types of Cookies We Use</h3>
        <h4>Necessary Cookies</h4>
        <p>These cookies are essential for the website to function correctly. They enable core features like security, navigation, and accessibility.</p>

        <h4>Technical Cookies</h4>
        <p>These cookies ensure that website features work smoothly, such as login sessions, page loading optimization, and caching.</p>

        <h4>Functional Cookies</h4>
        <p>These cookies help us remember your preferences, such as language settings and saved items in a shopping cart.</p>

        <h4>Analytical Cookies</h4>
        <p>These cookies collect data on how visitors use our website to improve performance and user experience.</p>

        <h4>Advertisement Cookies</h4>
        <p>These cookies are used to deliver personalized ads based on browsing behavior. They help us serve relevant advertisements through third-party ad platforms.</p>

        <h3>4. Managing Your Cookie Preferences</h3>
        <p>You can manage or disable cookies in the following ways:</p>
        <ul>
            <li><strong>Browser Settings:</strong> Most web browsers allow users to modify cookie preferences or disable them entirely.</li>
            <li><strong>Cookie Banner:</strong> Our website provides a cookie consent banner where you can accept, reject, or customize cookies.</li>
            <li><strong>Third-Party Opt-Outs:</strong> Some advertising networks offer tools to opt out of targeted advertising.</li>
        </ul>

        <h3>5. Updates to This Policy</h3>
        <p>
            We may update this Cookie Policy from time to time. Any changes will be posted on this page, 
            so we recommend checking back periodically.
        </p>
        <h3>Example Cookie Categories:</h3>
        <strong>Technical Cookies:</strong> Essential for website functionality (e.g., login, security).  
        <strong>Functional Cookies:</strong> Store user preferences (e.g., language settings, theme choices).  
        <strong>Advertisement Cookies:</strong> Used for targeted ads based on user behavior.  
        <strong>Necessary Cookies:</strong> Minimum required cookies for site usability (e.g., consent tracking).  
    </div>
    <?php
}

// Register plugin settings
function easycookiesplus_register_settings() {
    register_setting('easycookiesplus_settings_group', 'easycookiesplus_enable_banner');
    register_setting('easycookiesplus_settings_group', 'easycookiesplus_banner_title');
    register_setting('easycookiesplus_settings_group', 'easycookiesplus_banner_text');
    register_setting('easycookiesplus_settings_group', 'easycookiesplus_cookie_policy_text');
    register_setting('easycookiesplus_settings_group', 'easycookiesplus_banner_position');
    register_setting('easycookiesplus_settings_group', 'easycookiesplus_banner_bg_color');
    register_setting('easycookiesplus_settings_group', 'easycookiesplus_button_color');
    register_setting('easycookiesplus_settings_group', 'easycookiesplus_button_text_color');

    add_settings_section('easycookiesplus_main_section', 'Main Settings', null, 'easycookiesplus');

    add_settings_field('easycookiesplus_enable_banner', 'Enable Cookie Banner', 'easycookiesplus_enable_banner_field', 'easycookiesplus', 'easycookiesplus_main_section');
    add_settings_field('easycookiesplus_banner_title', 'Banner Title', 'easycookiesplus_banner_title_field', 'easycookiesplus', 'easycookiesplus_main_section');
    add_settings_field('easycookiesplus_banner_text', 'Banner Text', 'easycookiesplus_banner_text_field', 'easycookiesplus', 'easycookiesplus_main_section');
    add_settings_field('easycookiesplus_cookie_policy_text', 'Cookie Policy Text', 'easycookiesplus_cookie_policy_text_field', 'easycookiesplus', 'easycookiesplus_main_section');
}
add_action('admin_init', 'easycookiesplus_register_settings');

// Fields for banner enabling
function easycookiesplus_enable_banner_field() {
    $value = get_option('easycookiesplus_enable_banner', 'yes');
    echo '<input type="checkbox" name="easycookiesplus_enable_banner" value="yes" ' . checked($value, 'yes', false) . '>';
}

// Field for banner title
function easycookiesplus_banner_title_field() {
    $value = get_option('easycookiesplus_banner_title', 'Manage Your Cookie Preferences');
    echo '<input type="text" name="easycookiesplus_banner_title" value="' . esc_attr($value) . '" style="width:100%;">';
}

// Fields for banner text
function easycookiesplus_banner_text_field() {
    $value = get_option('easycookiesplus_banner_text', 'We use cookies to improve your experience.');
    echo '<input type="text" name="easycookiesplus_banner_text" value="' . esc_attr($value) . '" style="width:100%;">';
}

// Fields for cookie policy text
function easycookiesplus_cookie_policy_text_field() {
    $value = get_option('easycookiesplus_cookie_policy_text', 'Here you can describe your cookie policy.');
    echo '<textarea name="easycookiesplus_cookie_policy_text" rows="5" style="width:100%;">' . esc_textarea($value) . '</textarea>';
}



// Display the floating cookie banner
function easycookiesplus_display_banner() {
    if (get_option('easycookiesplus_enable_banner', 'yes') === 'yes' && empty($_COOKIE['easycookiesplus_hidden'])) {
        $banner_title = esc_html(get_option('easycookiesplus_banner_title', 'Manage Your Cookie Preferences'));
        $cookie_policy_text = esc_html(get_option('easycookiesplus_cookie_policy_text', 'Here you can describe your cookie policy.'));

        ?>
        <div id="easycookiesplus-banner" style="position: fixed; bottom: 20px; left: 50%; transform: translateX(-50%); background: #333; color: #fff; padding: 15px; border-radius: 5px; width: 300px;">
            <h3><?php echo $banner_title; ?></h3>
            <p><?php echo esc_html(get_option('easycookiesplus_banner_text', 'We use cookies to improve your experience.')); ?></p>
            <button id="accept-cookies">Accept</button>
            <button id="reject-cookies">Reject</button>
            <button id="show-policy">Cookie Policy</button>
            <button id="close-banner">Close</button>
            <div id="cookie-policy-text" style="display:none; padding: 10px; background: #444; color: #fff; border-radius: 5px; margin-top: 10px; max-height: 200px; overflow: auto;">
                <p id="policy-content"><?php echo $cookie_policy_text; ?></p>
            </div>
            <small style="display: block; text-align: center; margin-top: 10px;">Powered by NicoleDigital</small>
            <!-- Small "X" button to close banner with white color -->
            <button id="close-banner-x" style="position: absolute; top: 5px; right: 5px; background: transparent; border: none; color: #ffffff; font-size: 20px; cursor: pointer;">✖</button>
        </div>
        <script>
            document.getElementById('close-banner').addEventListener('click', function() {
                document.getElementById('easycookiesplus-banner').style.display = 'none';
                document.cookie = "easycookiesplus_hidden=true; max-age=86400; path=/"; // Hides banner for 24 hours
            });

            document.getElementById('close-banner-x').addEventListener('click', function() {
                document.getElementById('easycookiesplus-banner').style.display = 'none';
                document.cookie = "easycookiesplus_hidden=true; max-age=86400; path=/"; // Hides banner for 24 hours
            });

            document.getElementById('show-policy').addEventListener('click', function() {
                var policyText = document.getElementById('cookie-policy-text');
                policyText.style.display = policyText.style.display === 'none' ? 'block' : 'none';
            });
        </script>
        <?php
    }
}
add_action('wp_footer', 'easycookiesplus_display_banner');
